(ns org.domaindrivenarchitecture.build.terragrunt
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [org.domaindrivenarchitecture.build.devops :as d]
            [org.domaindrivenarchitecture.build.devops.domain :as dd]
            [org.domaindrivenarchitecture.build.terragrunt.domain :as dterra]))

(def default
  (merge d/default {}))

(defn-spec plan nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (apply t/shell (dd/clean-build-dir-command final))
    (apply t/shell (dd/create-build-dir-command final))
    (apply t/shell (dterra/copy-terragrunt-command final))
    (apply t/shell (dterra/plan-command final))))
