(ns dda.build.devops
  (:require
   [clojure.spec.alpha :as s]
   [dda.build.devops.domain :as domain]))

(s/def ::name ::domain/name)
(s/def ::module ::domain/module)
(s/def ::stage ::domain/stage)
(s/def ::project-root-path ::domain/project-root-path)
(s/def ::build-dir-name ::domain/build-dir-name)

(s/def ::devops
  (s/keys :req-un [::name]
          :opt-un [::module ::stage ::project-root-path ::build-dir-name]))

(def default {:name "dda-backup"
              :project-root-path "."
              :build-dir-name "target"
              :stage "dev"})
