(ns dda.build.image
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [dda.build.devops :as d]
            [dda.build.devops.domain :as dd]
            [dda.build.image.domain :as domain]))

(def default
  (merge d/default {}))

(defn-spec dbuild nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (apply t/shell (dd/clean-build-dir-command final))
    (apply t/shell (dd/create-build-dir-command final))
    (apply t/shell (domain/copy-image-command final))
    (apply t/shell (domain/dbuild-command final))))
