(ns dda.build.terragrunt
  (:require [orchestra.core :refer [defn-spec]]
            [dda.build.devops :as d]
            [dda.build.terragrunt.domain :as domain]
            [dda.build.infrastructure :as i]))

(def default
  (merge d/default {}))

(defn-spec plan nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (i/execute (domain/clean-build-dir-command final) final)
    (d/create-build-dir final)
    (i/execute (domain/copy-terragrunt-command final) final)
    ))
