(ns dda.build.terragrunt.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]))

(s/def ::devops
  (s/keys :req-un [::name ::stage ::project-root-path ::build-dir-name ::debug ::dry-run ::module]
          :opt-un []))

(defn-spec clean-build-dir-command seq?
  [devops ::devops]
  ["rm"  "-rf" (d/build-path (dissoc devops :module))])

(defn-spec copy-terragrunt-command seq?
  [devops ::devops]
  (let [{:keys [module]} devops]
    ["cp" "." (d/build-path devops) "&&" "cp" module (d/build-path devops)]))
