(ns dda.build.terragrunt
  (:require [orchestra.core :refer [defn-spec]]
            [dda.build.devops :as d]
            [dda.build.terragrunt.domain :as domain]
            [dda.build.infrastructure :as i]))

(def default
  (merge d/default {}))

(defn-spec clean-build-dir! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (i/execute (domain/clean-build-dir-command final) final)))

(defn-spec copy-terragrunt! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (doseq [c (domain/copy-terragrunt-command final)]
      (i/execute c final))))

(defn-spec terragrunt-plan! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (doseq [c (domain/terragrunt-plan-command final)]
      (i/execute c final))))

(defn-spec plan nil?
  [devops ::d/devops]
  (clean-build-dir! devops)
  (d/create-build-dir devops)
  (copy-terragrunt! devops)
  (terragrunt-plan! devops))
