(ns dda.build.terragrunt
  (:require [orchestra.core :refer [defn-spec]]
            [clojure.spec.test.alpha :as st]
            [dda.build.devops :as d]
            [dda.build.terragrunt.domain :as domain]
            [dda.build.infrastructure :as i]))

(st/instrument `clean-build-dir!)

(def default
  (merge d/default {:autoapply false}))

(defn-spec clean-build-dir! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (i/execute! (domain/clean-build-dir-command final) final)))

(defn-spec copy-terragrunt! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (doseq [c (domain/copy-terragrunt-command final)]
      (i/execute! c final))))

(defn-spec terragrunt-plan! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (doseq [c (domain/terragrunt-plan-command final)]
      (i/execute! c final))))

(defn-spec terragrunt-apply! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (doseq [c (into (domain/terragrunt-apply-command final)
                    (domain/terragrunt-output-command final))]
      (i/execute! c final))))

(defn-spec terragrunt-destroy! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (doseq [c (domain/terragrunt-destroy-command final)]
      (i/execute! c final))))

(defn-spec plan! nil?
  [devops ::d/devops]
  (clean-build-dir! devops)
  (d/create-build-dir! devops)
  (copy-terragrunt! devops)
  (terragrunt-plan! devops))

(defn-spec apply! nil?
  [devops ::d/devops]
  (clean-build-dir! devops)
  (d/create-build-dir! devops)
  (copy-terragrunt! devops)
  (terragrunt-apply! devops))

(defn-spec destroy! nil?
  [devops ::d/devops]
  (clean-build-dir! devops)
  (d/create-build-dir! devops)
  (copy-terragrunt! devops)
  (terragrunt-destroy! devops))

(st/instrument `clean-build-dir!)
(st/instrument `copy-terragrunt!)
(st/instrument `terragrunt-plan!)
(st/instrument `terragrunt-apply!)
(st/instrument `terragrunt-destroy!)
