(ns dda.c4k-common.namespace.namespace-internal
  (:require 
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.yaml :as yaml]))

(s/def ::namespace string?)

(def config? (s/keys :req-un [::namespace]
                     :opt-un []))

(defn-spec generate-namespace  map?
  [config config?]
  (let [{:keys [namespace]} config]
    (->
     (yaml/load-as-edn "namespace/namespace.yaml")
     (assoc-in [:metadata :name] namespace))))