(ns dda.c4k-stats.shynet
  (:require
   [clojure.spec.alpha :as s]
   [clojure.string :as str]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.namespace :as ns]
   [dda.c4k-common.predicate :as cp]
   [dda.c4k-common.ingress :as ing]))

(s/def ::django-secret-key cp/bash-env-string?)
(s/def ::allowed-hosts (s/coll-of string?))

(def config? (s/keys :req-un [::ns/namespace
                              ::ing/fqdn
                              ::allowed-hosts]))

(def auth? (s/keys :req-un [::django-secret-key]))

(defn-spec config-env map?
  [config config?]
  (let [{:keys [namespace allowed-hosts]} config]
    (->
     (ns/load-and-adjust-namespace "shynet/config-env.yaml" namespace)
     (#(assoc-in % [:data :ALLOWED_HOSTS]
                 (str/join "," allowed-hosts))))))

(defn-spec webserver-deployment map?
  [config config?]
  (let [{:keys [namespace]} config]
    (ns/load-and-adjust-namespace "shynet/webserver-deployment.yaml" namespace)))

(defn-spec worker-deployment map?
  [config config?]
  (let [{:keys [namespace]} config]
    (ns/load-and-adjust-namespace "shynet/worker-deployment.yaml" namespace)))

(defn-spec redis-statefulset map?
  [config config?]
  (let [{:keys [namespace]} config]
    (ns/load-and-adjust-namespace "shynet/statefulset.yaml" namespace)))

(defn-spec service-redis map?
  [config config?]
  (let [{:keys [namespace]} config]
    (ns/load-and-adjust-namespace  "shynet/service-redis.yaml" namespace)))

(defn-spec service-webserver map?
  [config config?]
  (let [{:keys [namespace]} config]
    (ns/load-and-adjust-namespace  "shynet/service-webserver.yaml" namespace)))

(defn-spec config-objects seq?
  [config config?]
  [(config-env config)
   (webserver-deployment config)
   (worker-deployment config)
   (redis-statefulset config)
   (service-webserver config)
   (service-redis config)])

(defn-spec auth-objects seq?
  [config config?
   auth auth?]
  (let [{:keys [namespace]} config
        {:keys [django-secret-key postgres-db-user postgres-db-password]} auth]
    [(->
      (ns/load-and-adjust-namespace "shynet/secret.yaml" namespace)
      (assoc-in [:stringData :DJANGO_SECRET_KEY] django-secret-key)
      (assoc-in [:stringData :DB_USER] postgres-db-user)
      (assoc-in [:stringData :DB_PASSWORD] postgres-db-password))]))