(ns dda.c4k-stats.stats
  (:require
   [clojure.spec.alpha :as s]
   [clojure.string :as str]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.namespace :as ns]
   [dda.c4k-common.ingress :as ing]))

(def config? (s/keys :req-un [::ns/namespace
                              ::ing/fqdn]))

(defn-spec etc map?
  [config config?]
  (let [{:keys [namespace fqdn]} config]
    (-> 
     (ns/load-and-adjust-namespace "stats/etc-configmap.yaml" namespace)
     (#(assoc-in % [:data :website.conf]
                 (str/replace
                  (-> % :data :website.conf)
                  #"FQDN"
                  fqdn))))))

(defn-spec config-objects seq?
  [config config?]
  (let [{:keys [namespace]} config]
    [(etc config)
     (ns/load-and-adjust-namespace "stats/content-configmap.yaml" namespace)
     (ns/load-and-adjust-namespace "stats/deployment.yaml" namespace)
     (ns/load-and-adjust-namespace "stats/service.yaml" namespace)]))
