(ns dda.backup.management.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core :as core]))

(s/def ::restic-repository string?)
(s/def ::backup-path string?)
(s/def ::certificate-file string?)
(s/def ::password-file string?)

(s/def ::config
  (s/keys :req-un [::restic-repository ::backup-path]
          :opt-un [::certificate-file ::password-file]))

(defn-spec init-repo-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    (cond 
      (some? certificate-file)
      [ ["restic" "-r" (str restic-repository "/" backup-path) "--cacert" certificate-file "-v" "init"]]
      (some? password-file)
      [["restic" "-r" (str restic-repository "/" backup-path) "--password-file" password-file "-v" "init"]]
      :else
      [ ["restic" "-r" (str restic-repository "/" backup-path) "-v" "init"]]
      )))

(defn-spec list-snapshot-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    (cond
      (some? certificate-file)
      [["restic" "-r" (str restic-repository "/" backup-path) "--cacert" certificate-file "-v" "snapshots"]]
      (some? password-file)
      [["restic" "-r" (str restic-repository "/" backup-path) "--password-file" password-file "-v" "snapshots"]]
      :else
      [["restic" "-r" (str restic-repository "/" backup-path) "-v" "snapshots"]])))
