(ns dda.backup.management
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core :as core]
   [dda.backup.management.domain :as domain]
   [dda.backup.infrastructure :as i]))

(s/def ::config
  (s/keys :req-un [::domain/restic-repository ::domain/backup-path]
          :opt-un [::domain/certificate-file ::core/debug ::core/dry-run]))

(defn-spec initalized? boolean?
  [config ::config]
  (let [config-w-defaults (merge core/default config)]
    (try
      (i/execute! [["restic" "--password-file" "restic-pwd" "--repo" "restic-repo" "check"]] config-w-defaults)
      true
      (catch Exception e false)
      )))


(defn-spec init! nil?
  [config ::config]
  (let [config-w-defaults (merge core/default config)]
    (i/execute! (domain/init-repo-command config-w-defaults) config-w-defaults)))
