(ns dda.backup.management.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core :as core]))

(s/def ::restic-repository string?)
(s/def ::backup-path string?)
(s/def ::certificate-file string?)
(s/def ::password-file string?)

(s/def ::config
  (s/keys :req-un [::restic-repository ::backup-path]
          :opt-un [::certificate-file ::password-file]))

(defn repo-command
  [config
   commands]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    [(into
       ["restic" "-r" (str restic-repository "/" backup-path) "-v"]
       (concat
        (cond
          (some? certificate-file)
          ["--cacert" certificate-file]
          (some? password-file)
          ["--password-file" password-file]
          :else
          [])
        commands))]))

(defn-spec check-repo-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    (repo-command config ["check"])))

(defn-spec init-repo-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    (repo-command config ["init"])))

(defn-spec unlock-repo-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    (repo-command config ["--cleanup-cache" "unlock"])))

(defn-spec list-snapshot-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file password-file restic-repository backup-path]} config]
    (repo-command config ["snapshots"])))
