(ns dda.backup.restore.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.backup.core.domain :as cd]))

(defn-spec restore-dir-command ::cd/commands
  [config ::cd/config
   snapshot-id string?]
  (let [{:keys [directory]} config
        config-wo-dir (dissoc config :directory)]
    (into [["rm" "-rf" directory]]
          (cd/repo-command config-wo-dir ["restore" snapshot-id "--target" directory]))))
