(ns dda.backup.management
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as cd]
   [dda.backup.management.domain :as domain]
   [dda.backup.core :as core]
   [dda.backup.infrastructure :as i]))

(s/def ::config
  (s/keys :req-un [::cd/restic-repository ::cd/backup-path]
          :opt-un [::cd/certificate-file ::cd/directory ::cd/debug 
                   ::cd/dry-run ::cd/days-to-keep ::cd/months-to-keep]))

(defn-spec initalized? boolean?
  [config ::config]
  (let [config-w-defaults (merge core/default config)]
    (try
      (i/execute! (domain/check-repo-command config-w-defaults) config-w-defaults)
      true
      (catch Exception e false)
      )))

(defn-spec init! nil?
  [config ::config]
  (let [config-w-defaults (merge core/default config)]
    (when (not (initalized? config-w-defaults))
      (i/execute! (domain/init-repo-command config-w-defaults) config-w-defaults))))

(defn-spec unlock! nil?
  [config ::config]
  (let [config-w-defaults (merge core/default config)]
    (i/execute! (domain/unlock-repo-command config-w-defaults) config-w-defaults)))

(defn-spec forget! nil?
  [config ::config]
  (let [config-w-defaults (merge core/default config)]
    (i/execute! (domain/forget-command config-w-defaults) config-w-defaults)))
