(ns dda.backup.restore
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as cd]
   [dda.backup.restore.domain :as domain]
   [dda.backup.core :as core]
   [dda.backup.management :as mgm]
   [dda.backup.infrastructure :as i]))

(def default (merge core/default {:snapshot-id "latest"}))

(s/def ::config
  (s/keys :req-un [::domain/target-directory
                   ::cd/restic-repository ::cd/backup-path]
          :opt-un [::domain/snapshot-id ::cd/certificate-file ::cd/directory ::cd/debug ::cd/dry-run]))

(defn-spec restore! nil?
  [config ::config]
  (let [config-w-defaults (merge default config)]
    (mgm/unlock! config-w-defaults)
    (i/execute!
     (domain/restore-dir-command config-w-defaults)
     config-w-defaults)))