(ns dda.backup.restore.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as cd]))

(s/def ::target-directory string?)
(s/def ::snapshot-id string?)

(s/def ::config
  (s/keys :req-un [::target-directory ::snapshot-id
                   ::cd/restic-repository ::cd/backup-path]
          :opt-un [::cd/certificate-file ::cd/password-file ::cd/directory]))

(defn-spec restore-dir-command ::cd/commands
  [config ::config]
  (let [{:keys [target-directory snapshot-id]} config]
    (into [["rm" "-rf" target-directory]]
          (cd/repo-command config ["restore" snapshot-id "--target" target-directory]))))
