(ns dda.backup.core
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [clojure.string :as st]))

(def default {:dry-run false
              :debug false})

(s/def ::execution
  (s/keys :req-un []
          :opt-un [::dry-run 
                   ::debug
                   ::execution-directory]))

(defn-spec env-or-file string?
  [name string?]
  (let [name-upper (st/upper-case name)
        name-lower (st/lower-case name)
        from-env (System/getenv name-upper)]
    (if (some? from-env)
      from-env
      (slurp name-lower))))
