(ns dda.backup.restic
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.restic.domain :as domain]
   [dda.backup.core :as core]
   [dda.backup.infrastructure :as i]))

(def default
  (merge core/default
         {:days-to-keep 30
          :months-to-keep 12}))

(s/def ::restic-config
  (s/merge ::core/execution 
           (s/keys :req-un [::domain/restic-repository
                            ::domain/backup-path]
                   :opt-un [::domain/certificate-file
                            ::domain/password-file
                            ::domain/days-to-keep
                            ::domain/months-to-keep])))

(defn-spec initalized? boolean?
  [restic-config ::restic-config]
  (let [config-w-defaults (merge core/default restic-config)]
    (try
      (i/execute! (domain/check-repo-command config-w-defaults) config-w-defaults)
      true
      (catch Exception e false))))

(defn-spec init! nil?
  [restic-config ::restic-config]
  (let [config-w-defaults (merge core/default restic-config)]
    (when (not (initalized? config-w-defaults))
      (i/execute! (domain/init-repo-command config-w-defaults) config-w-defaults))))

(defn-spec unlock! nil?
  [restic-config ::restic-config]
  (let [config-w-defaults (merge core/default restic-config)]
    (i/execute! (domain/unlock-repo-command config-w-defaults) config-w-defaults)))

(defn-spec forget! nil?
  [restic-config ::restic-config]
  (let [config-w-defaults (merge core/default restic-config)]
    (i/execute! (domain/forget-command config-w-defaults) config-w-defaults)))