(ns dda.backup.infrastructure
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [dda.backup.core.domain :as core]))

(defn-spec execute! nil?
  [commands ::core/commands
   config ::core/execution]
  (let [{:keys [dry-run debug]} config]
    (doseq [c commands]
      (when debug
        (println c))
      (when-not dry-run
        (apply t/shell c)))))
