(ns dda.backup.infrastructure
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [dda.backup.core.domain :as core]))

(defn-spec execute-out! string?
  [command ::core/command
   config ::core/execution]
  (let [{:keys [dry-run debug]} config]
    (when debug
      (println command))
    (when-not dry-run
      (:out (t/shell {:out :string :err :string} (clojure.string/join " " command))))))

(defn-spec execute-single! string?
  [command ::core/command
   config ::core/execution]
  (let [{:keys [dry-run debug]} config]
    (when debug
      (println command))
    (when-not dry-run
      (:out (t/shell {:err :string} (clojure.string/join " " command))))))


(defn-spec execute! nil?
  [commands ::core/commands
   config ::core/execution]
  (let [{:keys [dry-run debug]} config]
    (doseq [c commands]
      (when-not dry-run
        (apply t/shell c)))))