(ns dda.backup.config
  "{:test huhu :long-name #env LOGNAME :gopass-pw #gopass [sopra/test.de] :gopass-field-url #gopass [sopra/test.de url]}"
  (:require [aero.core :as aero]
            [dda.backup.core :as bc]
            [dda.backup.infrastructure :as i]))

(defmethod aero/reader 'env-or-file
  [{:keys [profile] :as opts} tag value]
  (bc/env-or-file value))

(defmethod aero/reader 'gopass
  [{:keys [profile] :as opts} tag value]
  (i/execute-out! (into ["gopass" "show" "-y" "-o"] value) {}))

(defn read-config 
  [file]
  (try 
    (aero/read-config file)
    (catch Exception e 
      (do (println (str "Warn: " e))
          {}))
    ))
