(ns dda.backup.monitoring
  (:require
    [orchestra.core :refer [defn-spec]]
    [dda.backup.monitoring.domain :as domain]
    [dda.backup.infrastructure :as i]
    [clojure.string :as st]))

(def default {:url "http://prometheus-pushgateway.monitoring.svc.cluster.local:9091/metrics/job"
              :name "backup"
              :metrics {:kube_job_status_active 0
                        :kube_job_status_failed 1
                        :kube_job_status_succeeded 0
                        :kube_job_status_completion_time ""
                        :kube_job_status_start_time ""}})

(defn- config-w-defaults
  [config]
    (merge default config))

(defn-spec send-metrics! nil?
  [config ::domain/config]
  (let [config-2-use (config-w-defaults config)
        {:keys [url name]} config-2-use]
    (i/post (str url "/" name) (domain/collect-metrics config-2-use))))
