; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.dda-versioncrate
  (:require
    [pallet.actions :as actions]
    [pallet.stevedore :as stevedore]
    [pallet.script :as script]
    [pallet.crate :as crate]
    [pallet.api :as api]
    [pallet.node-value :as nv]
    [pallet.core.session :refer [session session!]]
    [clojure.tools.logging :as logging]
    [clojure.string :refer [join]]
    [org.domaindrivenarchitecture.pallet.crate.base.version-utils :as utils]
    ))

; todo: - version auslesen -> settings phase (?)
;       - was ist session/node-values? -> markdown erstellen
;       - clojure testcases erstellen!

(defn selector_from_lesseq [verfrom]
  (fn [vremote vpallet] (and (not (utils/ver_eq vremote vpallet))
                             (not (nil? vremote)) 
                             (utils/ver_lesseq vremote verfrom))))

(defn selector_from_to [verfrom verto]
  (fn [vremote vpallet] (and (utils/ver_eq vremote verfrom) 
                             (utils/ver_eq vpallet verto))))

(defn selector_clean_install []
  (fn [vremote vpallet] (nil? vremote)))

(defn selector_always []
  (fn [vremote vpallet] true))

(crate/defplan ^:dynamic install-with-versions
  [app-name version version-set config]
  (let [statefile (utils/install-marker-path app-name)
        nv_version (nv/make-node-value (nv/node-value-symbol))]
    ; set version to `nil`, if no state file exists
    (actions/plan-when-not
      (stevedore/script (file-exists? ~statefile))
      (actions/as-action (nv/assign-node-value nv_version nil))
      )
    ; set version according to state file, if file exists
    (actions/plan-when
      (stevedore/script (file-exists? ~statefile))
      (let [statefilecontent (actions/remote-file-content statefile)]
        (actions/as-action (nv/assign-node-value nv_version (utils/ver_fromstr @statefilecontent) ))
        ))    
    (actions/as-action (logging/info
                         "Nodeversion of" app-name "is" (nv/node-value nv_version (session)) ";" 
                         "Palletversion is" version))
    ; plan actions for each selector
    (doseq [entry version-set]
      (actions/plan-when 
        (apply (:selector entry) [(nv/node-value nv_version (session)) version])
        (doseq [f (:install-fn entry)] (f app-name version config)
      ))
      (utils/node-write-state app-name version))
    ))