(ns dda.build.terragrunt.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]))

(s/def ::tg-output-filenname string?)
(s/def ::autoapply boolean?)

(s/def ::config
  (s/keys :req-un [::d/name ::d/stage ::d/project-root-path ::d/build-dir-name ::d/debug 
                   ::d/dry-run ::d/module ::tg-output-filenname ::autoapply]
          :opt-un []))

(defn-spec clean-build-dir-command seq?
  [config ::config]
  ["rm"  "-rf" (d/build-path (dissoc config :module))])

(defn-spec copy-terragrunt-command seq?
  [config ::config]
  (let [{:keys [module]} config
        config-wo-module (dissoc config :module)]
    [["bash" "-c" (str "cp *.hcl " (d/build-path config-wo-module))]
     ["cp" "-r" module (d/build-path config-wo-module)]]))

(defn-spec terragrunt-plan-command seq?
  [config ::config]
  [[{:dir (d/build-path config)} "terragrunt" "init"]
   [{:dir (d/build-path config)} "terragrunt" "plan"]])

(defn-spec terragrunt-apply-command seq?
  [config ::config]
  [[{:dir (d/build-path config)} "terragrunt" "init"]
   [{:dir (d/build-path config)} "terragrunt" "apply" "-auto-approve"]])

(defn-spec terragrunt-destroy-command seq?
  [config ::config]
  [[{:dir (d/build-path config)} "terragrunt" "init"]
   [{:dir (d/build-path config)} "terragrunt" "destroy"]])

(defn-spec terragrunt-output-command seq?
  [config ::config]
  (let [{:keys [tg-output-filenname]} config]
    [[{:dir (d/build-path config)} "bash" "-c" (str "terragrunt output -json > " tg-output-filenname)]]))

(defn-spec output-path string?
  [config ::config]
  (let [{:keys [tg-output-filenname]} config]
    (str (d/build-path config) "/" tg-output-filenname)))
