(ns dda.build.c4k.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]
            [dda.c4k-common.predicate :as pred]))

(s/def ::c4k-output-filenname string?)
(s/def ::autoapply boolean?)

(s/def ::sensitive boolean?)

(s/def ::type vector?)

(s/def ::fqdn pred/fqdn-string?)
(s/def ::ipv4 pred/ipv4-string?)
(s/def ::ipv6 pred/ipv6-string?)
(s/def ::value 
  (s/keys :req-un [::fqdn ::ipv4 ::ipv6]))

(s/def ::out 
  (s/keys :req-un [::sensitive ::type ::value]))

(s/def ::tf-out
  (s/keys :req-un [::out]))

(s/def ::c4k-config-filename string?)
(s/def ::c4k-auth-filename string?)

(s/def ::config
  (s/keys :req-un [::d/name ::d/stage ::d/project-root-path ::d/build-dir-name ::d/debug
                   ::d/dry-run ::d/module ::c4k-output-filenname ::autoapply ::c4k-config-filename ::c4k-auth-filename]
          :opt-un []))

(defn-spec config-path string?
  [config ::config]
  (let [{:keys [c4k-config-filename]} config]
    (str (d/build-path config) "/" c4k-config-filename)))

(defn-spec auth-path string?
  [config ::config]
  (let [{:keys [c4k-auth-filename]} config]
    (str (d/build-path config) "/" c4k-auth-filename)))

(defn-spec output-path string?
  [config ::config]
  (let [{:keys [c4k-output-filename]} config]
    (str (d/build-path config) "/" c4k-output-filename)))

(defn-spec clean-build-dir-command seq?
  [config ::config]
  ["rm"  "-rf" (d/build-path (dissoc config :module))])

(defn-spec c4k-uberjar-command seq?
  [config ::config]
  (let [{:keys [module]} config
        executable-name (str "c4k-" module "-standalone.jar")]
    [["bash" "-c" (str executable-name (config-path config) (auth-path config) ">" (output-path config))]]))

(defn-spec c4k-graalvm-command seq?
  [config ::config]
  (let [{:keys [module]} config
        executable-name (str "c4k-" module)]
    [["bash" "-c" (str executable-name (config-path config) (auth-path config) ">" (output-path config))]]))
