(ns dda.build.infrastructure
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [dda.build.devops.domain :as d]))

(defn-spec execute! nil?
  [command seq?
   devops ::d/devops]
  (let [{:keys [dry-run debug]} devops]
    (when debug
      (println command))
    (when-not dry-run
      (apply t/shell command))))

(defn-spec execute-output! string?
  [command seq?
   devops ::d/devops]
  (let [{:keys [dry-run debug]} devops]
    (when debug
      (println command))
    (when-not dry-run
      (->> command
           (t/shell {:out :string})
           :out
           clojure.string/trim))))