(ns dda.image.install
  (:require [babashka.tasks :as tasks]))

(defn curl-and-check!
  [filename artifact-url sha256-url]
  (let [filepath (str "/tmp/" filename)]
    (tasks/shell "curl" "-SsLo" filepath artifact-url)
    (tasks/shell "curl" "-SsLo" "/tmp/checksum" sha256-url)
    (tasks/shell "bash" "-c" (str "echo \" " filepath "\"|tee -a /tmp/checksum"))
    ;(tasks/shell "sha256sum" "-c" "--status" "/tmp/checksum")
    ))

(defn tar-install!
  [filename binname]
  (let [filepath (str "/tmp/" filename)]
    (tasks/shell "tar" "-C" "/tmp" "-xzf" filepath)
    (tasks/shell "install" "-m" "0740" "-o" "root" "-g" "root" (str "/tmp/" binname) "/usr/local/bin/")))

(defn install!
  [filename & {:keys [mod target-name] :or {mod "0740"}}]
  (let [final-target-name (if (some? target-name) target-name filename)]
    (tasks/shell "install" "-m" mod "-o" "root" "-g" "root"
                 (str "/tmp/" filename)
                 (str "/usr/local/bin/" final-target-name))))
