(ns dda.build.image.domain
  (:require [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]))

(defn-spec copy-image-command seq?
  [devops ::d/devops]
  (let [{:keys [name]} devops]
    ["cp" "-r" "image" (d/build-path devops)]))

(defn-spec dbuild-command seq?
  [devops ::d/devops]
  (let [{:keys [name]} devops]
    ["docker" "build" "-t" name "--file"
     (str (d/build-path devops) "/image/Dockerfile")
     (str (d/build-path devops) "/image")]))
