(ns dda.build.c4k
  (:require [orchestra.core :refer [defn-spec]]
            [clojure.spec.test.alpha :as st]
            [cheshire.core :as cs]
            [dda.build.devops :as devops]
            [dda.build.terragrunt :as tg]
            [dda.build.config :as cfg]
            [dda.build.c4k.domain :as domain]
            [dda.build.infrastructure :as i]))

(st/instrument `clean-build-dir!)

(def default
  (merge devops/default
         tf/default
         {:c4k-output "c4k-app.yaml"
          :c4k-config-input "c4k-config.edn"
          :c4k-auth-input "c4k-auth.edn"}))

(s/def ::c4k (s/merge 
              ::devops/devops
              ::tg/tg
              (s/keys :opt-un [::domain/c4k-output ::domain/c4k-config-input ::domain/c4k-auth-input])))

(defn-spec clean-build-dir! nil?
  [devops ::c4kg]
  (let [config (merge default devops)]
    (i/execute! (domain/clean-build-dir-command config) config)))

(defn-spec run-c4k-jar! nil?
  [devops ::c4kg]
  (let [config (merge default devops)]
    (doseq [c (domain/c4k-uberjar-command config)]
      (i/execute! c config))))

(defn-spec run-c4k-bin! nil?
  [devops ::c4kg]
  (let [config (merge default devops)]
    (doseq [c (domain/c4k-graalvm-command config)]
      (i/execute! c config))))

(defn-spec write-c4k-objects! nil?
  [devops ::c4kg
   tf-out ::tg-domain/tf-out]
  (let [config (merge default devops)
        {:keys [module c4k-auth-input c4k-config-input c4k-output]} config]
    (->> (cfg/read-config (domain/config-path config))
         (merge {:fqdn (:fqdn (:value (:out tf-out)))})
         (cs/generate-string)
         (spit (domain/config-path config)))
    (->> (cfg/read-config (domain/config-auth config))
         (cs/generate-string)
         (spit (domain/config-auth config))
    (run-c4k-jar! config)))

(st/instrument `clean-build-dir!)
(st/instrument `run-c4k-jar!)
(st/instrument `run-c4k-bin!)
(st/instrument `write-c4k-objects!)
