(ns dda.build.provs
  (:require    [clojure.spec.alpha :as s]
               [clojure.spec.test.alpha :as st]
               [orchestra.core :refer [defn-spec]]
               [cheshire.core :refer [generate-string]]
               [dda.build.c4k :as c4k]
               [dda.build.terragrunt :as tg]
               [dda.build.provs.domain :as domain]
               [dda.build.infrastructure :as i]))

(def default
  (merge c4k/default
         {:k3s-output-filename "out_k3sServerConfig.yaml"
          :k3s-provision-user "root"
          :echo false}))
(s/def ::provs (s/merge ::c4k/c4k
                        (s/keys 
                         :req-un [::domain/email ::domain/fqdn ::domain/ipv4 ::domain/ipv6]
                         :opt-un [::domain/echo ::domain/k3s-output-filename ::domain/k3s-provision-user])))

(defn-spec run-provs-server! nil?
  [devops ::provs
   tf-out ::tg/tf-out]
  (let [config (merge default devops)]
    (doseq [c (domain/provs-server-command config tf-out)]
      (i/execute! c config))))

(defn-spec write-k3s-config! nil?
  "Create a server config for provs using tf-out and write it to a file
   
   Requires ':email' to be set, otherwise certs will not work
   Default: out_k3sServerConfig.yaml
   can be changed by adding another value for ':k3s-output-filename'
   "
  [devops ::provs
   tf-out ::tg/tf-out]
  (let [config (merge default devops)
        tf-out-k3s-config (domain/create-k3s-config config tf-out)]
    (->> tf-out-k3s-config
         (generate-string)
         (spit (domain/output-path config)))))

(st/instrument `run-provs-server!)
(st/instrument `write-k3s-config!)