(ns dda.build.devops.domain
  (:require
   [clojure.spec.alpha :as s]
   [clojure.string :as str]
   [orchestra.core :refer [defn-spec]]))

(s/def ::name string?)
(s/def ::module string?)
(s/def ::stage string?)
(s/def ::project-root-path string?)
(s/def ::build-dir-name string?)
(s/def ::debug boolean?)
(s/def ::dry-run boolean?)

(s/def ::devops
  (s/keys :req-un [::name ::stage ::project-root-path ::build-dir-name ::debug ::dry-run]
          :opt-un [::module]))

(defn-spec build-path string?
  [devops ::devops]
  (let
   [{:keys [project-root-path build-dir-name name module]} devops]
    (str/join
     "/"
     (filter
      some?
      [project-root-path build-dir-name name module]))))

(defn-spec clean-build-dir-command seq?
  [devops ::devops]
  (let [{:keys [name]} devops]
    ["rm"  "-rf" (build-path devops)]))

(defn-spec create-build-dir-command seq?
  [devops ::devops]
  (let [{:keys [name]} devops]
    ["mkdir" "-p" (build-path devops)]))
