(ns dda.build.provs
  (:require [clojure.spec.alpha :as s]
            [clojure.spec.test.alpha :as st]
            [orchestra.core :refer [defn-spec]]
            [cheshire.core :refer [generate-string]]
            [dda.build.c4k :as c4k]
            [dda.build.terragrunt :as tg]
            [dda.build.config :as cfg]
            [dda.build.provs.domain :as domain]
            [dda.build.infrastructure :as i]))

(def default
  (merge c4k/default
         {:k3s-output-filename "out_k3sServerConfig.json"
          :k3s-auth-input "k3s-auth.edn"
          :k3s-provision-user "root"
          :echo false}))
(s/def ::provs (s/merge ::c4k/c4k
                        (s/keys
                         :req-un [::domain/email]
                         :opt-un [::domain/echo ::domain/k3s-output-filename ::domain/k3s-provision-user 
                                  ::domain/k3s-grafana-user ::domain/k3s-grafana-token
                                  ::domain/k3s-hcloudApiToken ::domain/k3s-encryptionPassphrase])))

(defn-spec run-provs-server! nil?
  [devops ::provs
   tf-out ::tg/tf-out]
  (let [config (merge default devops)]
    (doseq [c (domain/provs-server-command config tf-out)]
      (i/execute! c config))))

(defn-spec write-k3s-config! nil?
  [devops ::provs
   tf-out ::tg/tf-out]
  (let [config (merge default devops)]
    (->> (domain/create-k3s-config 
          (merge (cfg/read-config (domain/auth-path config)) config) 
          tf-out)
         (generate-string)
         (spit (domain/output-path config)))))

(st/instrument `run-provs-server!)
(st/instrument `write-k3s-config!)