(defproject org.domaindrivenarchitecture/dda-collected-crate "0.3.0"
  :description "The dda collected crate"
  :url "https://www.domaindrivenarchitecture.org"
  :pallet {:source-paths ["src"]}
  :license {:name "Apache License, Version 2.0"
            :url "https://www.apache.org/licenses/LICENSE-2.0.html"}
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [com.palletops/leaven "0.3.1"]
                 [com.palletops/pallet "0.8.11"]
                 [com.palletops/stevedore "0.8.0-beta.7"]
                 [com.palletops/git-crate "0.8.0-alpha.2" :exclusions [org.clojure/clojure]]
                 [org.domaindrivenarchitecture/dda-config-crate "0.3.1"]
                 [org.domaindrivenarchitecture/dda-user-crate "0.3.0"]
                 [org.domaindrivenarchitecture/httpd "0.2.1"]
                 [org.domaindrivenarchitecture/dda-iptables-crate "0.2.2"]
                 [org.domaindrivenarchitecture/dda-tomcat-crate "0.1.2"]
                 [org.domaindrivenarchitecture/dda-mysql-crate "0.1.1"]]
  :profiles {:dev
             {:dependencies
              [[com.palletops/pallet "0.8.11" :classifier "tests"]
               [org.domaindrivenarchitecture/dda-pallet-commons "0.1.0" :classifier "tests"]]
              :plugins
              [[com.palletops/pallet-lein "0.8.0-alpha.1"]]}
              :leiningen/reply
               {:dependencies [[org.slf4j/jcl-over-slf4j "1.7.2"]]
                :exclusions [commons-logging]}}
   :local-repo-classpath true
   :repositories [["snapshots" :clojars]
                  ["releases" :clojars]]
   :deploy-repositories [["snapshots" :clojars]
                         ["releases" :clojars]]
   :classifiers {:tests {:source-paths ^:replace ["test"]
                         :resource-paths ^:replace []}})