; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.d2rq
  (:require
      [pallet.actions :as actions]
      [pallet.api :as api]
      [pallet.crate :as crate]
      [pallet.stevedore :as stevedore]
      ;TODO - deprecated use basecrate instead
      [org.domaindrivenarchitecture.pallet.crate.dda-base-0-3 :as dda-base]
      [org.domaindrivenarchitecture.pallet.crate.config-0-3 :as config]
      [org.domaindrivenarchitecture.pallet.crate.tomcat.app :as tomcat-app]
      [org.domaindrivenarchitecture.pallet.crate.tomcat.app-config :as tomcat-config]
      [org.domaindrivenarchitecture.pallet.crate.d2rq.app :as d2rq-app]
      ))


(def facility :dda-d2rq)
(def d2rq-base "/var/lib/d2rq")


(defn install
  [app-name config]
  (let [linked-data-war-url (:linked-data-war-url config)]
    (tomcat-app/install-tomcat7
      :custom-tomcat-home (str d2rq-base "/tomcat7"))
    (d2rq-app/install-d2rq-war-file (str d2rq-base "/tomcat7" linked-data-war-url))))

(defn configure
  [app-name config]                      
  (tomcat-app/configure-tomcat7
   :custom-tomcat-home (str d2rq-base "/tomcat7")
    :lines-server-xml d2rq-app/server-xml
    :lines-setenv-sh (tomcat-config/setenv-sh
                       :Xmx "1024m"
                       :Xms "256m"
                       :MaxPermSize "128m")))

(def ^:dynamic with-d2rq
  (api/server-spec
    :phases 
    {:install
     (api/plan-fn
       (dda-base/install-with-instances
         (name facility)
         (config/get-nodespecific-additional-config facility)
         install
         ))
     :configure
     (api/plan-fn
       (dda-base/configure-with-instances
         (name facility)
         (config/get-nodespecific-additional-config facility)
         configure
         ))
    }))
