; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.config-test-spec
  (:require
    [pallet.api :as api]
    [pallet.compute :as compute]
    [org.domaindrivenarchitecture.pallet.crate.config :as sut]
    ))
  
(def ^:dynamic provider
  (compute/instantiate-provider
    "node-list"
    :node-list [["test1" "test-group" "192.168.35.18" :ubuntu]
                ]))

(def ^:dynamic test-group
  (api/group-spec
    "test-group"
    :extends [(sut/with-config nil)]
    )
  )
  
(defn test-it []
  (api/lift
     test-group
     :compute provider
     :phase '(:settings)
    ))