; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.validators
  (:require
    [org.domaindrivenarchitecture.validatable :as validatable]
    ))

(defn get-value-from-path [graph & path]
  {:pre [(or 
           (empty? path)
           (map? graph))]}
  (if (empty? path)
    graph
    (recur ((first path) graph) (rest path))
    )
  )

(defn validate-entry 
  [[k v]]
  (if (satisfies? validatable/Validatable v)
    (validatable/validate v)
    [(str "not validateable " k ", " v)] 
    )
  )

(defn validate-map [m]
  (into 
    []
    (mapcat validate-entry m))
  )


(defn validate-not-empty [object-under-test & path]
  (try
    (if (some? (apply (partial get-value-from-path object-under-test) path))
      []
      [(str "vallidation-not-empty: " path)])
    (catch AssertionError e
      [(str "vallidation-not-empty: " path \newline e)]
      )
    )
  )