# dda-iptable-crate

A new iptables crate inspired by https://github.com/pallet/iptables-crate.
Features are
 * uses iptables-persistent
 * provides ipv4 & ipv6 support

Compatible with
* pallet version: 0.8
* target os: ubuntu 14.04

Artefacts can be found at
* https://clojars.org/org.domaindrivenarchitecture/dda-iptables-crate

## Usage

Usage example in pallet group definition:

```
(ns org.domaindrivenarchitecture.pallet.crate.iptables
  (:require
   [org.domaindrivenarchitecture.pallet.crate.config :as config]
   [org.domaindrivenarchitecture.pallet.crate.iptables :as ip-tables]
   [org.domaindrivenarchitecture.pallet.crate.iptables.iptables-config :as ipt-config]))
    
(def config 
  {:dda-hardening 
    {:custom-iptables ipt-config/default-web-firewall}})
    
(def linked-data-group
  (api/group-spec
    "linked-data-group"
     :extends [(config/with-config config) 
              ip-tables/with-firewall
              ...]))
```

## Dependencies

```
(defproject ...
  :dependencies [...
                 [org.domaindrivenarchitecture.org/dda-config-crate "0.1.0"]
                 [org.domaindrivenarchitecture/dda-basic-crate "0.1.0-SNAPSHOT"]
                 [org.domaindrivenarchitecture/dda-iptables-crate "0.2.0-SNAPSHOT"]]
  ....
  )
```

## License

Copyright © 2015 meissa GmbH
Licensed under the Apache License, Version 2.0 (the "License");
