; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.iptables
  (:require
   [pallet.api :as api]
   [org.domaindrivenarchitecture.pallet.crate.config :as config]
   ;TODO - deprecated use basecrate instead
   [org.domaindrivenarchitecture.pallet.crate.dda-base-0-3 :as dda-base]
   [org.domaindrivenarchitecture.pallet.crate.iptables.iptables-config :as ipt-config]
   [org.domaindrivenarchitecture.pallet.crate.iptables.iptables-app :as app]
    ))

(def facility :dda-firewall)

(defn install 
  [app-name config]
  (app/install-firewall))

(defn configure 
  [app-name config]
  (let [custom-iptables (-> config :custom-iptables)]
    (when (empty? custom-iptables)
      (app/configure-iptables)
      (app/configure-iptables :rules custom-iptables))
    (app/reload-config)))

(def with-firewall
  (api/server-spec
    :phases 
    {:install
     (api/plan-fn
       (dda-base/install-with-instances
         (name facility)
         (config/get-nodespecific-additional-config facility)
         install))
     :configure
     (api/plan-fn
       (dda-base/configure-with-instances
         (name facility)
         (config/get-nodespecific-additional-config facility)
         configure))
     }))