; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.iptables
  (:require
   [pallet.api :as api]
   [org.domaindrivenarchitecture.pallet.core.dda-crate :as dda-pallet]
   [org.domaindrivenarchitecture.pallet.core.dda-crate.config :as config]
   [org.domaindrivenarchitecture.pallet.crate.iptables.iptables-config :as ipt-config]
   [org.domaindrivenarchitecture.pallet.crate.iptables.iptables-app :as app]
    ))

(def dda-iptables-crate
  (dda-pallet/make-dda-crate
    :facility :dda-firewall
    :version [0 2 6]
    ))

(defn install 
  [app-name config]
  (app/install-firewall))

(defn configure 
  [app-name config]
  (let [custom-iptables (-> config :custom-iptables)]
    (when (empty? custom-iptables)
      (app/configure-iptables)
      (app/configure-iptables :rules custom-iptables))
    (app/reload-config)))

(defmethod dda-pallet/dda-configure
  :dda-firewall [dda-crate config]
  (configure (name (:facility dda-iptables-crate)) 
             (config/get-nodespecific-additional-config (:facility dda-iptables-crate))))

(defmethod dda-pallet/dda-install
  :dda-firewall [dda-crate config]
    (install (name (:facility dda-iptables-crate)) 
             (config/get-nodespecific-additional-config (:facility dda-iptables-crate))))

(def with-firewall
  (dda-pallet/create-server-spec dda-iptables-crate))


