(ns component.menu
  (:require [com.stuartsierra.component :as component]
            [schema.core :as s]))

(defrecord Menu []
  component/Lifecycle
  (start [this]
    (println "[menu] start")
    this)
  (stop [this]
    (println "[menu] stop")
    this))

(s/defn longest-uri-match
  [items :- [{(s/required-key :uri) s/Str
              s/Keyword s/Str}]
   uri :- s/Str]
  (->> items
       (map :uri)
       (filter #(.startsWith (str uri "/") %))
       (sort-by count)
       (last)))

(defn menu-active [{:keys [items] :as component} context]
  (let [parent (longest-uri-match items context)]
    (for [{:keys [label uri] :as item} items]
      (cond-> item
        (= parent uri) (assoc :active true)))))

(defn menu [& [m]]
  (map->Menu m))
