(ns component.modified
  (:require [clojure.java.io :as io])
  (:import java.io.File
           java.lang.String
           java.net.URL))

(defprotocol Modified
  (last-modified [f]))

(extend-protocol Modified
  java.net.URL
  (last-modified [f]
    (when (= (.getProtocol f) "file")
      (last-modified (io/file f))))
  java.lang.String
  (last-modified [f]
    (last-modified (io/file f)))
  java.io.File
  (last-modified [f]
    (.lastModified f)))

(defn out-of-date?
  "check if input files have been modified after output file"
  [input-files output-file]
  (<
   (last-modified output-file)
   (apply max 1 (map last-modified input-files))))
