(ns deploy.component.commit
  (:require [com.stuartsierra.component :as component]
            [deploy.component.shell :as shell]
            [deploy.component.config :as config]
            [clojure.spec :as s]))



(s/def ::remove-pattern string?)

(s/def ::component
  (s/keys :req-un [::config/common ::shell/std ::shell/no-abort ::shell/no-out]))

(s/fdef exec
        :args (s/cat :component ::component)
        :ret nil?)



(defn exec
  [{:keys             [std no-abort]
    {:keys [destdir]} :common
    :as               component}]

  (println "\n**Commit new version**")
  (shell/exec std
                  "git" "-C" destdir "add" "-A")
  (shell/exec no-abort
                  "git" "-C" destdir "commit" "-m" "release")

  (println "\n**Push and tag new version**")

  ;; FIXME: lookup the remotes here and the branch name

  (shell/exec std
                  "git" "-C" destdir "push" "-f" "hostgator" "heads/deploy:refs/heads/deploy")
  (shell/exec std
                  "git" "-C" destdir "push" "origin" "heads/deploy:refs/heads/deploy")
  (shell/exec std
                  "git" "-C" destdir "tag" "-f" "deploy"))

(defrecord Commit []
  component/Lifecycle
  (start [component]
    (println "[commit] start")
    (exec component)
    component)
  (stop [component]
    (println "[commit] stop")
    component))

(defn commit [& [m]]
  (map->Commit m))
