(ns deploy.component.config
  (:require [com.stuartsierra.component :as component]
            [clojure.spec :as s]
            [clojure.java.io :as io]))



(s/def ::directory #(.isDirectory (io/file %)))
(s/def ::relativepath #(not (.isAbsolute (io/file %))))

(s/def ::destdir
  (s/and string?
         ::directory
         ::relativepath))

(s/def ::common
  (s/keys :req-un [::destdir]))



(defrecord Config []
  component/Lifecycle
  (start [component]
    (println "[config] start")
    component)
  (stop [component]
    (println "[config] stop")
    component))

(defn config [& [m]]
  (map->Config m))
