(ns deploy.component.copy
  (:require [com.stuartsierra.component :as component]
            [clojure.java.io :as io]
            [deploy.component.config :as config]
            [clojure.spec :as s]))

(s/def ::resources-to-copy
  (s/map-of string? string?))

(s/def ::component
  (s/keys :req-un [::config/common ::resources-to-copy]))

(s/fdef exec
        :args (s/cat :component ::component)
        :ret nil?)


(defn exec [{{:keys [destdir]} :common
             :keys [resources-to-copy]
             :as component}]
  (doseq [[resource target] resources-to-copy]
    (println (format "Create %s" target))
    (io/copy (io/file (io/resource resource))
             (io/file destdir target))))

(defrecord Copy []
  component/Lifecycle
  (start [component]
    (println "[copy] start")
    (exec component)
    component)
  (stop [component]
    (println "[copy] stop")
    component))

(defn copy [& [m]]
  (map->Copy m))
