(ns deploy.component.prepare
  (:require [com.stuartsierra.component :as component]
            [clojure.java.shell :as sh]
            [deploy.component.shell :as shell]
            [deploy.component.config :as config]
            [clojure.java.io :as io]
            [clojure.spec :as s]
            [clojure.spec.test :as stest]))

(s/def ::origin
  string?)

(s/def ::remotes
  (s/and
   (s/keys :req-un [::origin])
   (s/map-of keyword? string?)))

(s/def ::config
  (s/keys :req-un [::remotes
                   ::shell/std
                   ::shell/no-abort
                   ::shell/no-out
                   ::config/common]))

(s/fdef exec
        :args (s/cat :config ::config)
        :ret nil?)

#_(stest/instrument `exec)

#_(s/exercise ::config)

#_(exec {:remotes {:origin ""},
         :std {:print-cmd? false, :print-out? true, :print-err? false, :abort-on-error? false},
         :no-abort {:print-cmd? true, :print-out? true, :print-err? true, :abort-on-error? false},
         :no-out {:print-cmd? true, :print-out? true, :print-err? true, :abort-on-error? true},
         :common {:destdir "aksdlkasd"}})



(defn vcs-commited? []
  (->
   (sh/sh "git" "diff-index" "--quiet" "HEAD" "--")
   :exit
   (= 0)))

(defn exec [{:keys [remotes std no-abort no-out] {:keys [destdir]} :common :as component}]

  (assert (vcs-commited?) "uncommited changes in git repository")

  ;; (assert (.isDirectory (io/file destdir))
  ;;         (format "directory %s does not exist" destdir))

  ;; (assert (not (.isAbsolute (io/file destdir)))
  ;;         (format "directory %s is absolute" destdir))

  ;; (assert (contains? remotes :origin)
  ;;         (format "no remote origin provided (%s)" remotes))

  (println "\n**Add remotes**")
  (doseq [[remote path] remotes]
    (shell/exec no-abort
                "git" "-C" destdir "remote" "add" (name remote) path))

  (println "\n**Checkout deploy branch**")
  (shell/exec std
              "git" "-C" destdir "fetch" "--all")
  (shell/exec std
              "git" "-C" destdir "checkout" "-f"  "-B" "deploy"  "origin/deploy")

  (println "\n**Purge work dir**")
  (shell/exec no-out
              "find" destdir
              "-name" ".git" "-prune"
              "-o"
              "-type" "f"
              "-exec" "rm" "-v" "{}" ";")
  (shell/exec std
              "find"
              destdir
              "-empty" "-type" "d" "-delete"))

(defrecord Prepare []
  component/Lifecycle
  (start [component]
    (println "[prepare] start")
    (exec component)
    component)
  (stop [component]
    (println "[prepare] stop")
    component))

(defn prepare [& [m]]
  (map->Prepare m))
