(ns doctex.async
  (:refer-clojure :exclude [chunk])
  (:require [clojure.core.async :as a]
            [integrant.core :as ig]))

;;; implementation

(defn- take-until-timeout [in]
  (let [timer (a/timeout 100)]
    (a/go-loop [collect []]
      (let [[v ch] (a/alts! [in timer])]
        (if (or (= ch timer) (nil? v))
          collect
          (recur (conj collect v)))))))

(defn throttle [in out]
  (a/go-loop []
    (let [v (a/<! in)]
      (when-not (nil? v)
        (as-> (take-until-timeout in) _
          (a/<! _)
          (seq _)
          (cons v _)
          (distinct _)
          (a/onto-chan out _ false)
          (a/<! _))
        (recur)))))

(defn chunk [in out]
  (a/go-loop []
    (let [v (a/<! in)]
      (when-not (nil? v)
        (as-> (take-until-timeout in) _
          (a/<! _)
          (seq _)
          (cons v _)
          (distinct _)
          (vec _)
          (a/>! out _))
        (recur)))))

(defn consume [ch f]
  (a/go-loop []
    (let [x (a/<! ch)]
      (when-not (nil? x)
        (f x)
        (recur)))))

;;; integrant

(defmethod ig/init-key
  ::chan-sliding
  [_ {:keys [n] :or {n 100}}]
  (a/chan (a/sliding-buffer n)))

(defmethod ig/halt-key!
  ::chan-sliding
  [_ ch]
  (a/close! ch))

(defmethod ig/init-key
  ::consume
  [_ {:keys [ch f]}]
  (consume ch f))

(defmethod ig/init-key
  ::throttle
  [_ {:keys [in out]}]
  (throttle in out))

(defmethod ig/init-key
  ::chunk
  [_ {:keys [in out]}]
  (chunk in out))
