(defproject org.dsteurer/doctex "0.1.4"
  :description "latex wrapper to craft mathematical documents"
  :url "http://dsteurer.org"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :target-path "target/%s"
  :deploy-repositories [["releases" :clojars]]
  ;; :main ^:skip-aot doctex.main

  :dependencies
  [[org.clojure/clojure "1.9.0-alpha15"]
   [integrant "0.4.0"]
   [selmer "1.10.7"
    :exclusions [hiccups]]
   [hawk "0.2.11"]
   [org.clojure/core.async "0.3.442"]
   [duct/core "0.1.1"]
   [duct/module.logging "0.1.1"]
   [com.stuartsierra/dependency "0.2.0"]
   [io.forward/yaml "1.0.6"]
   [cheshire "5.7.1"]
   ]

  :profiles
  {:dev
   {:dependencies   [[integrant/repl "0.2.0"]
                     [eftest "0.3.0"]]
    :source-paths   ["dev/src"]
    :resource-paths ["dev/resources"]
    :repl-options
    {:init-ns user}}})
