(defproject org.dsteurer/latex-compile "0.1.2-SNAPSHOT"
  :description "compile daemon for latex and bibtex"
  :url "http://dsteurer.org"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  :main latex-compile.core
  :target-path "target/%s"

  :dependencies
  [[org.clojure/clojure "1.8.0"]
   [com.stuartsierra/component "0.3.2"]
   [org.clojure/tools.reader "0.10.0"]
   [prismatic/plumbing "0.5.3"]
   [de.ubercode.clostache/clostache "1.4.0"]
   [org.clojure/core.async "0.3.441"]
   [juxt/dirwatch "0.2.3"]
   [clj-text-decoration "0.0.3"]
   [me.raynes/fs "1.4.6"]
   ]

  :repl-options
  {:init-ns user
   :welcome (println "Type (dev) to start")}

  :profiles
  {:dev     {:dependencies [[reloaded.repl "0.2.3"]]
             :source-paths ["dev" "src"]}
   :uberjar {:aot :all}})
