(ns load-system.core
  (:require [duct.util.system :as d]
            [meta-merge.core :refer [meta-merge]]))

(defn get-config
  "generate config from sources and bindings"
  [sources bindings]
  (->> sources
       (map #(d/read-config % bindings))
       (apply meta-merge)))

(defn configure-endpoints
  "configure endpoints of system according to config"
  [system {:keys [endpoints config]}]
  (->> endpoints
       (keys)
       (select-keys config)
       (meta-merge system)))

(defn load-system
  "load system from sources and bindings with configured endpoints"
  [sources bindings]
  (-> (d/load-system sources bindings)
      (configure-endpoints (get-config sources bindings))))
